EvaluateSystemScript("colors.js");

function Menu()
{
  if (this instanceof Menu == false) {
    return new Menu();
  }

  // default properties
  this.font            = GetSystemFont()
  this.window_style    = GetSystemWindowStyle()
  this.arrow           = GetSystemArrow();
  this.up_arrow        = GetSystemUpArrow();
  this.down_arrow      = GetSystemDownArrow();
  this.escape_function = function() { }

  this.items = new Array();
}

// add item
Menu.prototype.addItem = function(name, callback, color) {

  if (color == undefined) {
    color = White;
  }

  var item = new Object;
  item.name     = name;
  item.callback = callback;
  item.color    = color;
  this.items[this.items.length] = item;
}

// execute
Menu.prototype.execute = function(x, y, w, h) {
  with (this) {
    var background = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());

    var text_height = font.getHeight();
    var shown_items = Math.floor(h / text_height);

    var selection = 0;
    var top_selection = 0;

    while (true) {
      // draw background
      background.blit(0, 0);

      // draw the window
      window_style.drawWindow(x, y, w, h);

      // draw the menu items
      for (var i = 0; i < shown_items; i++) {
        if (i < items.length) {
          font.setColorMask(Black);
          font.drawText(x + 16 + 1, y + i * text_height + 1, items[i + top_selection].name);
          font.setColorMask(items[i + top_selection].color);
          font.drawText(x + 16,     y + i * text_height,     items[i + top_selection].name);
        }
      }

      // draw the selection arrow
      arrow.blit(x, y + (selection - top_selection) * text_height);

      // draw the up and down arrows if necessary
      if (top_selection > 0) {
        up_arrow.blit(x + w - up_arrow.width, y);
      }
      if (top_selection + shown_items < items.length) {
        down_arrow.blit(x + w - down_arrow.width, y + text_height * shown_items - down_arrow.height);
      }

      FlipScreen();

      // handle keypresses
      while (AreKeysLeft()) {
        switch (GetKey()) {
          case KEY_ENTER: {
            var item = items[selection];
            item.callback();
            return;
          }

          case KEY_ESCAPE: {
            escape_function();
            return;
          }

          case KEY_DOWN: {
            if (selection < items.length - 1) {
              selection++;
              if (selection >= top_selection + shown_items) {
                top_selection++;
              }
            }
            break;
          }

          case KEY_UP: {
            if (selection > 0) {
              selection--;
              if (selection < top_selection) {
                top_selection--;
              }
            }
            break;
          }

        }
      } // end handle input
    }

  } // end with
}

//Battle Menu

function BMenu()
{
  var arrow2 = LoadImage("Arrow2.png");
  var arrow3 = LoadImage("Arrow3.png");

  if (this instanceof Menu == false) {
    return new Menu();
  }

  // default properties
  this.font            = GetSystemFont()
  this.window_style    = GetSystemWindowStyle()
  this.arrow           = GetSystemArrow();
  this.up_arrow        = GetSystemUpArrow();
  this.down_arrow      = GetSystemDownArrow();
  this.escape_function = function() { }

  this.items = new Array();
}

// add item
Menu.prototype.addItem = function(name, callback, color) {

  if (color == undefined) {
    color = White;
  }

  var item = new Object;
  item.name     = name;
  item.callback = callback;
  item.color    = color;
  this.items[this.items.length] = item;
}

// execute
Menu.prototype.execute = function(x, y, w, h) {
  with (this) {
    var background = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());

    var text_height = font.getHeight();
    var shown_items = Math.floor(h / text_height);

    var selection = 0;
    var top_selection = 0;

    while (true) {
      // draw background
      background.blit(0, 0);

      // draw the window
      window_style.drawWindow(x, y, w, h);

      // draw the menu items
      for (var i = 0; i < shown_items; i++) {
        if (i < items.length) {
          font.setColorMask(Black);
          font.drawText(x + 16 + 1, y + i * text_height + 1, items[i + top_selection].name);
          font.setColorMask(items[i + top_selection].color);
          font.drawText(x + 16,     y + i * text_height,     items[i + top_selection].name);
        }
      }

      // draw the selection arrow
      arrow.blit(x, y + (selection - top_selection) * text_height);

      if (Player.BMenuTemp == true)
      {
        if (selection == 0)
        {
          if (items[0 + top_selection].name == Monster1.name)
          {
          LoadImage("Arrow2.png").blit(Monster1.posx, Monster1.posy);
          }
          if (items[0 + top_selection].name == Monster2.name)
          {
          LoadImage("Arrow2.png").blit(Monster2.posx, Monster2.posy);
          }
          if (items[0 + top_selection].name == Monster3.name)
          {
          LoadImage("Arrow2.png").blit(Monster3.posx, Monster3.posy);
          }
          if (items[0 + top_selection].name == Monster4.name)
          {
          LoadImage("Arrow2.png").blit(Monster4.posx, Monster4.posy);
          }

        }        
        if (selection == 1)
        {
          if (items[1 + top_selection].name == Monster1.name)
          {
          LoadImage("Arrow2.png").blit(Monster1.posx, Monster1.posy);
          }
          if (items[1 + top_selection].name == Monster2.name)
          {
          LoadImage("Arrow2.png").blit(Monster2.posx, Monster2.posy);
          }
          if (items[1 + top_selection].name == Monster3.name)
          {
          LoadImage("Arrow2.png").blit(Monster3.posx, Monster3.posy);
          }
          if (items[1 + top_selection].name == Monster4.name)
          {
          LoadImage("Arrow2.png").blit(Monster4.posx, Monster4.posy);
          }
        }
        if (selection == 2)
        {
          if (items[2 + top_selection].name == Monster1.name)
          {
          LoadImage("Arrow2.png").blit(Monster1.posx, Monster1.posy);
          }
          if (items[2 + top_selection].name == Monster2.name)
          {
          LoadImage("Arrow2.png").blit(Monster2.posx, Monster2.posy);
          }
          if (items[2 + top_selection].name == Monster3.name)
          {
          LoadImage("Arrow2.png").blit(Monster3.posx, Monster3.posy);
          }
          if (items[2 + top_selection].name == Monster4.name)
          {
          LoadImage("Arrow2.png").blit(Monster4.posx, Monster4.posy);
          }
        }
        if (selection == 3)
        {
          if (items[3 + top_selection].name == Monster1.name)
          {
          LoadImage("Arrow2.png").blit(Monster1.posx, Monster1.posy);
          }
          else if (items[3 + top_selection].name == Monster2.name)
          {
          LoadImage("Arrow2.png").blit(Monster2.posx, Monster2.posy);
          }
          else if (items[3 + top_selection].name == Monster3.name)
          {
          LoadImage("Arrow2.png").blit(Monster3.posx, Monster3.posy);
          }
          else if (items[3 + top_selection].name == Monster4.name)
          {
          LoadImage("Arrow2.png").blit(Monster4.posx, Monster4.posy);
          }
        }
      }
      else if (Player.BPMenuTemp == true)
      {
        if (selection == 0)
        {
          if (items[0 + top_selection].name == Player.name)
          {
          LoadImage("Arrow3.png").blit(Player.P1x - 20, Player.P1y - 8);
          }
          if (items[0 + top_selection].name == Player2.name)
          {
          LoadImage("Arrow3.png").blit(Player.P2x - 20, Player.P2y - 8);
          }
          if (items[0 + top_selection].name == Player3.name)
          {
          LoadImage("Arrow3.png").blit(Player.P3x - 20, Player.P3y - 8);
          }
        }        
        if (selection == 1)
        {
          if (items[1 + top_selection].name == Player.name)
          {
          LoadImage("Arrow3.png").blit(Player.P1x - 20, Player.P1y - 8);
          }
          if (items[1 + top_selection].name == Player2.name)
          {
          LoadImage("Arrow3.png").blit(Player.P2x - 20, Player.P2y - 8);
          }
          if (items[1 + top_selection].name == Player3.name)
          {
          LoadImage("Arrow3.png").blit(Player.P3x - 20, Player.P3y - 8);
          }
        }
        if (selection == 2)
        {
          if (items[2 + top_selection].name == Player.name)
          {
          LoadImage("Arrow3.png").blit(Player.P1x - 20, Player.P1y - 8);
          }
          if (items[2 + top_selection].name == Player2.name)
          {
          LoadImage("Arrow3.png").blit(Player.P2x - 20, Player.P2y - 8);
          }
          if (items[2 + top_selection].name == Player3.name)
          {
          LoadImage("Arrow3.png").blit(Player.P3x - 20, Player.P3y - 8);
          }
        }
      }
      // draw the up and down arrows if necessary
      if (top_selection > 0) {
        up_arrow.blit(x + w - up_arrow.width, y);
      }
      if (top_selection + shown_items < items.length) {
        down_arrow.blit(x + w - down_arrow.width, y + text_height * shown_items - down_arrow.height);
      }

      FlipScreen();

      // handle keypresses
      while (AreKeysLeft()) {
        switch (GetKey()) {
          case KEY_ENTER: {
            Player.BMenuTemp = false;
            Player.BPMenuTemp = false;
            var item = items[selection];
            item.callback();
            return;
          }

          case KEY_ESCAPE: {
            Player.BMenuTemp = false;
            Player.BPMenuTemp = false;
            escape_function();
            return;
          }

          case KEY_DOWN: {
            if (selection < items.length - 1) {
              selection++;
              if (selection >= top_selection + shown_items) {
                top_selection++;
              }
            }
            break;
          }

          case KEY_UP: {
            if (selection > 0) {
              selection--;
              if (selection < top_selection) {
                top_selection--;
              }
            }
            break;
          }

        }
      } // end handle input
    }
  } // end with
}
